import { getCompanyInfo, getAllProducts, getHomePageFeatures } from './contentful';

// Simple test to check if CMS is working
export async function testCMSConnection() {
  console.log('🔍 Testing CMS connection...');
  
  try {
    // Test company info
    console.log('📋 Fetching company info...');
    const companyInfo = await getCompanyInfo();
    console.log('✅ Company info:', companyInfo ? 'Found' : 'Using fallback');
    
    // Test products
    console.log('📦 Fetching products...');
    const products = await getAllProducts();
    console.log('✅ Products:', products.length > 0 ? `Found ${products.length} products` : 'Using fallback');
    
    // Test features
    console.log('⭐ Fetching features...');
    const features = await getHomePageFeatures();
    console.log('✅ Features:', features.length > 0 ? `Found ${features.length} features` : 'Using fallback');
    
    console.log('🎉 CMS connection test complete!');
    
    return {
      success: true,
      companyInfo: !!companyInfo,
      products: products.length,
      features: features.length
    };
    
  } catch (error) {
    console.error('❌ CMS connection failed:', error);
    return {
      success: false,
      error: error instanceof Error ? error.message : 'Unknown error'
    };
  }
}

// Run test if this file is executed directly
if (typeof window === 'undefined') {
  testCMSConnection().then(result => {
    console.log('Test result:', result);
  });
}